"""
Autor: Albert Wiedemann
Version: 1.0
"""

import random

class Generator:
    """
    Generiert zufaellige Bezeichner vom Typ String gegebener Laenge.
    """

    def __init__(self, laenge):
        """
        Initialisiert den Zufallsgenerator.
        :param laenge Die Laenge der zu generierenden Bezeichner
        """
        self.zufall = random.Random()
        self.zeichen = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j']
        self.laenge = laenge

    def BezeichnerGenerieren(self):
        """
        erzeugt einen neuen Bezeichner.
        :return der neue Bezeichner
        """
        resultat = ""
        for i in range(1, self.laenge + 1):
            resultat = resultat + self.zeichen[self.zufall.randint(0, len(self.zeichen) - 1)]
        return resultat


class TestSortieren:
    """
    Fuehrt die gewuenschten Laufzeittests durch.
    """

    def __init__(self, anzahl):
        """
        Legt die benoetigten Objekte an und besetzt die Attributwerte.
        :param anzahl Anzahl der zu sortierenden Datenelemente
        """
        self.anzahl = anzahl
        self.g = Generator(10)
        self.daten = [self.g.BezeichnerGenerieren() for _ in range(anzahl)]
        self.zaehlerBubble = 0
        self.zaehlerShaker = 0
        d = list(self.daten)
        self.BubbleSort(d)
        d = list(self.daten)
        self.ShakerSort(d)

    def BubbleSort(self, d):
        """
        Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
        :param d das zu sortierende Feld
        """
        for i in range(len(d)):
            for j in range(len(d) - 1):
                self.zaehlerBubble += 1
                if d[j] > d[j + 1]:
                    hilf = d[j]
                    d[j] = d[j + 1]
                    d[j + 1] = hilf

    def ShakerSort(self, d):
        """
        Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente im
        Hin- und Ruecklauf.
        :param d das zu sortierende Feld
        """
        pass

    def ZaehlerFuerBubbleSortGeben(self):
        """
        Meldet die Anzahl relevanter Operationen fuer die Sortierung durch Vertauschen
        falsch stehender Nachbarelemente.
        :return Anzahl der Operationen
        """
        return self.zaehlerBubble

    def ZaehlerFuerShakerSortGeben(self):
        """
        Meldet die Anzahl relevanter Operationen fuer die Sortierung durch Vertauschen
        falsch stehender Nachbarelemente im Hin- und Ruecklauf.
        :return Anzahl der Operationen
        """
        return self.zaehlerShaker


class SortierenTesten:
    """
    Hauptklasse des Programms.
    """

    def __init__(self):
        """
        Initialisiert ein Objekt dieser Klasse.
        """
        pass

    @staticmethod
    def main(anzahl):
        """
        Startet das Programm.
        """
        test = TestSortieren(anzahl)
        print("BubbleSort:   ", test.ZaehlerFuerBubbleSortGeben())
        print("ShakerSort:   ", test.ZaehlerFuerShakerSortGeben())

SortierenTesten.main(20)
