def ZeichenketteTeilen(zeichenkette):
    """
    Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste
    :param zeichenkette: zu teilende Zeichenkette
    :return: Liste mit Wörtern
    """
    wörter = []
    s = ""
    for zeichen in zeichenkette:
        if zeichen == ' ':
            wörter.append(s)
            s = ""
        else:
            s += zeichen
    wörter.append(s)
    return wörter


def LückentextGeben(dateiname):
    """
    Gibt den Lückentext aus der Datei zurück
    """
    with open(dateiname, 'r', encoding='utf-8') as file:
        return file.readline().strip()


def WörterAlsZeichenketteGeben(dateiname):
    """
    Gibt die einzusetzenden Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt zurück
    """
    with open(dateiname, 'r', encoding='utf-8') as file:
        file.readline()  # erste Zeile überspringen
        return file.readline().strip()


def ErgebnisAusgeben(wortlückeOhneBuchstabenplatzhalter):
    """
    Gibt das Ergebnis der Lösungssuche auf Konsole aus
    """
    ergebnis = ""
    for s in wortlückeOhneBuchstabenplatzhalter:
        ergebnis += s + " "
    print(ergebnis)


def PermutationWörterBestimmen(wörter):
    """
    Bestimmt alle Permutationen der Wörter
    :param wörter: Liste der Wörter
    :return: Liste aller Permutationen
    """
    if len(wörter) == 1:
        return [wörter]
    else:
        permutationen = []
        for i in range(len(wörter)):
            aktuellesWort = wörter[i]
            rest = wörter[:i] + wörter[i+1:]    # wörter[:i] beidetet alle Elemente vor Index i
                                                # wörter[i+1:] beidetet  alle Elemente nach Index i
                                                # -> wörter[:i] + wörter[i+1:] ist die Liste ohne das Wort mit Index i
            for p in PermutationWörterBestimmen(rest):
                permutationen.append([aktuellesWort] + p)


                if len(permutationen) % 1000 == 0:
                    print(f"{len(permutationen)} Permutationen erzeugt...")


        return permutationen


def PermutationenÜberprüfen(ergebnisPermutation, wortlückeMitBuchstabenplatzhalter):
    """
    Überprüft, ob eine Permutation in die Wortfolge mit Lücken passt
    """
    for p in ergebnisPermutation:
        wortlückeOhneBuchstabenplatzhalter = list(wortlückeMitBuchstabenplatzhalter)
        anzahlPassendeWorte = 0

        for j in range(len(p)):
            wortkandidat = p[j]
            wortlücke = wortlückeOhneBuchstabenplatzhalter[j]

            if wortlücke[-1] in [',', '.', '?', ';', '!']:
                satzzeichen = wortlücke[-1]
                wortlückeOhneSatzzeichen = wortlücke[:-1]
            else:
                wortlückeOhneSatzzeichen = wortlücke
                satzzeichen = ""

            wortPasstInLücke = False
            if len(wortkandidat) == len(wortlückeOhneSatzzeichen):
                wortPasstInLücke = all(
                    wortlückeOhneSatzzeichen[i] == wortkandidat[i] or wortlückeOhneSatzzeichen[i] == '_'
                    for i in range(len(wortkandidat))
                )

            if wortPasstInLücke:
                wortlückeOhneBuchstabenplatzhalter[j] = wortkandidat + satzzeichen
                anzahlPassendeWorte += 1
            else:
                break

        if anzahlPassendeWorte == len(wortlückeOhneBuchstabenplatzhalter):
            print("Ergebnis gefunden :-)")
            print(wortlückeOhneBuchstabenplatzhalter)
            print("und als Satz")
            ErgebnisAusgeben(wortlückeOhneBuchstabenplatzhalter)
            break


def DatenEinlesen(rätselnummer):
    """
    Öffnet abhängig von der Rätselnummer die passende Textdatei,
    liest die zwei Zeichenketten ein, trennt diese bei den Leerzeichen und gibt sie zurück
    :param rätselnummer: Eine Nummer zwischen 0 und 5
    :return: Tuple (wortlückeMitBuchstabenplatzhalter, wörter)
    """
    if 0 <= rätselnummer <= 4:
        dateiname = f"raetsel{rätselnummer}.txt"
        lückentext = LückentextGeben(dateiname)
        wörterAlsZeichenkette = WörterAlsZeichenketteGeben(dateiname)

        print("Fülle den Lückentext")
        print(lückentext)
        print("mit folgenden Wörtern")
        print(wörterAlsZeichenkette)

        wortlückeMitBuchstabenplatzhalter = ZeichenketteTeilen(lückentext)
        wörter = ZeichenketteTeilen(wörterAlsZeichenkette)
        return wortlückeMitBuchstabenplatzhalter, wörter
    else:
        print("Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!")
        return [], []


def LösenMitBruteForce(rätselnummer):
    """
    Hauptfunktion zur Lösung des Worträtsels
    """
    wortlückeMitBuchstabenplatzhalter, wörter = DatenEinlesen(rätselnummer)
    ergebnisPermutation = PermutationWörterBestimmen(wörter)
    PermutationenÜberprüfen(ergebnisPermutation, wortlückeMitBuchstabenplatzhalter)


# Startpunkt
if __name__ == "__main__":
    rätselnummer = 0  # Beispiel: Rätsel 0
    LösenMitBruteForce(rätselnummer)
