class BruteForceWortraetselLoeser:
    """
    Lösung zu 39. BWINf Runde 1 Aufgabe 1 über BruteForce:
    Alle möglichen Wortkombinationen werden durch die Permutationen bestimmt.
    Der Ansatz funktioniert nur mit dem ersten Text,
    die weiteren haben ein Speicherproblem (Heap)

    @author Peter Brichzin
    @version 11.11.24
    """

    def __init__(self, rätselnummer):
        """
        Worträtsel Konstruktor:
        - liest die Daten ein

        Zum Start der Lösung muss noch die Methode LösenMitBruteForce aufgerufen werden.

        :param rätselnummer: Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
        """
        # zu verteilende Wörter als Feld
        self.wörter = []

        # Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten
        self.wortlückeMitBuchstabenplatzhalter = []

        # Feld für das Endergebnis: zur Lücke passendes Wort (ohne Platzhalter "_" für fehlende Buchstaben)
        self.wortlückeOhneBuchstabenplatzhalter = []

        # Felder zur Bestimmung Speicherung der Permutationen (Brute Force)
        self.teilergebnisPermutation = []
        self.ergebnisPermutation = []

        self.DatenEinlesen(rätselnummer)
        self.wortlückeOhneBuchstabenplatzhalter = list(self.wortlückeMitBuchstabenplatzhalter)

    def LösenMitBruteForce(self):
        """
        Ermittelt die Lösung des Worträtsels
        """
        self.teilergebnisPermutation = []
        self.ergebnisPermutation = []
        self.PermutationWörterBestimmen()
        self.PermutationenÜberprüfen()

    def PermutationWörterBestimmen(self):
        """
        Methode PermutationWörterBestimmen bestimmt alle Permutationen der Wörter
        im Attribut wörter und speichert diese im Attribut ergebnisPermutation.
        """
        if len(self.wörter) == 1:                                   # Rekursionsende: nur ein Wort in der Menge
            self.teilergebnisPermutation.append(self.wörter[0])     # letztes Wort wird zum Teilergebnis hinzugefügt
            self.ergebnisPermutation.append(list(self.teilergebnisPermutation)) # Teilergebnis ist fertig -> wird in globalem Attribut gespeichert (als neue Liste)
            self.teilergebnisPermutation.pop()                      # Teilergebnis wird reduziert um das letzte Wort
        else:
            # Rekursionsschritt für alle Wörter die in der Wortmenge enthalten sind:
            # ein Wort wird genommen und über "teilergebnis" konkateniert mit allen Permutationen der restlichen Wörter

            for i in range(len(self.wörter)):
                # entsprechend dem Index wird das aktuelle Wort dem Teilergebnis hinzugefügt und aus der Wortliste entfernt
                aktuellesWort = self.wörter[i]
                self.teilergebnisPermutation.append(aktuellesWort)
                del self.wörter[i]
                # rekursiver Aufruf (mit Kopie der aktuellen Wortliste)
                self.PermutationWörterBestimmen()
                # Umkehrung der Schritte vor dem rekursiven Aufruf
                # aktuelles Wort wird vom Teilergebnis weggenommen und der Wortliste hinzugefügt
                self.wörter.insert(i, aktuellesWort)
                self.teilergebnisPermutation.pop()

    def PermutationenÜberprüfen(self):
        """
        Methode PermutationenÜberprüfen überprüft, ob eine der Permutationen in die Wortfolge mit Lücken passt
        und gibt diese gegebenenfalls aus.
        """
        for p in self.ergebnisPermutation:
            self.wortlückeOhneBuchstabenplatzhalter.clear()
            self.wortlückeOhneBuchstabenplatzhalter.extend(self.wortlückeMitBuchstabenplatzhalter)
            anzahlPassendeWorte = 0

            for j in range(len(p)):
                wortkandidat = p[j]
                wortlücke = self.wortlückeOhneBuchstabenplatzhalter[j]

                # Eliminierung der Satzzeichen
                if wortlücke[-1] in [',', '.', '?', ';', '!']:
                    satzzeichen = wortlücke[-1]
                    wortlückeOhneSatzzeichen = wortlücke[:-1]
                else:
                    wortlückeOhneSatzzeichen = wortlücke
                    satzzeichen = ""

                wortPasstInLücke = False
                if len(wortkandidat) == len(wortlückeOhneSatzzeichen):
                    wortPasstInLücke = all(
                        wortlückeOhneSatzzeichen[i] == wortkandidat[i] or wortlückeOhneSatzzeichen[i] == '_'
                        for i in range(len(wortkandidat))
                    )

                # eigentlicher Vergleich
                if wortPasstInLücke:
                    self.wortlückeOhneBuchstabenplatzhalter[j] = wortkandidat + satzzeichen
                    anzahlPassendeWorte += 1
                else:
                    break

            if anzahlPassendeWorte == len(self.wortlückeOhneBuchstabenplatzhalter):
                print("Ergebnis gefunden :-)")
                break

        print(self.wortlückeOhneBuchstabenplatzhalter)
        print("und als Satz")
        self.ErgebnisAusgeben()

    def ErgebnisAusgeben(self):
        """
        Gibt das Ergebnis der Lösungssuche auf Konsole aus
        """
        ergebnis = ""
        for s in self.wortlückeOhneBuchstabenplatzhalter:
            ergebnis += s + " "
        print(ergebnis)

    def DatenEinlesen(self, rätselnummer):
        """
        Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei,
        liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
        die Felder wörter bzw. wortlückeMitBuchstabenplatzhalter
        Falls eine falsche Nummer eingegeben wird, bricht das Programm mit einer FileNotFound Exception ab.

        :param rätselnummer: Eine Nummer zwischen 0 und 5
        """
        if 0 <= rätselnummer <= 4:
            dateiname = f"raetsel{rätselnummer}.txt"
            reader = TextFileReader(dateiname)

            lückentext = reader.LückentextGeben()
            wörterAlsZeichenkette = reader.WörterAlsZeichenketteGeben()

            print("Fülle den Lückentext")
            print(lückentext)
            print("mit folgenden Wörtern")
            print(wörterAlsZeichenkette)

            self.wortlückeMitBuchstabenplatzhalter = self.ZeichenketteTeilen(lückentext)
            self.wörter = self.ZeichenketteTeilen(wörterAlsZeichenkette)
        else:
            print("Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!")
            self.wortlückeMitBuchstabenplatzhalter = []
            self.wörter = []

    def ZeichenketteTeilen(self, zeichenkette):
        """
        Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste

        :param zeichenkette: zu teilende Zeichenkette
        :return: Liste mit Wörtern
        """
        wörter = []
        s = ""
        for zeichen in zeichenkette:
            if zeichen == ' ':
                wörter.append(s)
                s = ""
            else:
                s += zeichen
        wörter.append(s)
        return wörter


class TextFileReader:
    """
    File Reader zum Lesen der als Textdateien gegebenen Rätsel
    """

    def __init__(self, dateiname):
        with open(dateiname, 'r', encoding='utf-8') as file:
            self.inhalt = file.readlines()

    def LückentextGeben(self):
        """
        Gibt den Lückentext zurück
        """
        return self.inhalt[0].strip()

    def WörterAlsZeichenketteGeben(self):
        """
        Gibt die einzusetzenden Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt zurück
        """
        return self.inhalt[1].strip()
