"""Wörträtsel (Lösung zu 39. BWINf Runde 1 Aufgabe 1)

Objektorientierte Version wurde in eine imperative/prozedurale Fassung überführt.
Kamelhöckernotation, Methodennamen und Doc-Kommentare wurden beibehalten.

"""

from typing import List

__author__ = "Peter Brichzin"
__version__ = "6.1.25"


# /** zu verteilende Wörter als Feld */
wörter: List[str] = []

# /** Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten */
wortlücken: List[str] = []

# /** Lücken für die Wörter, die im Idealfall nur noch Buchstaben und Satzzeichen, 
#  * aber keine den Plätzen für Buchstaben (gekennzeichnet durch "_") enthalten
#  */
wortlückenErgebnis: List[str] = []

# /** für jede Lücke die Indizes der Wörter die passen */
wortkandidatenFürLücken: List[List[int]] = []

# /** Hilfsvariablen für die Lösungsalgorithmen */
# true, falls das Wort mit diesem Index bereits verwendet wurde
wortVerwendet: List[bool] = []
# speichert den Index des wortes passend zur Lücke
wortzuordnungFürIndizesLücken: List[int] = []
wortzuordnungFürIndizesLückenFinal: List[int] = []


def WortkandidatenBestimmen():
    """
    Für jede Lücke (Liste wortlücken) werden die Wörter (Liste Wörter)
    bestimmt, die in die Lücke passen. Gespeichert werden zu jedem Index der
    Liste wortlücken alle Indizes (der Liste Wörter) passender Wörter.
    Bei der Überprüfung jedes Kandidaten werden
    - mögliche Satzzeichen der Lücken vorab eliminiert
    - zunächst die Länge verglichen
    - nur bei gleicher Länge zeichenweise mit gegebenen Buchstaben bzw. dem Unterstrich als Zeichen für die Lücke verglichen.
    """
    # ToDo



def LösungskandidatenAuswählenGreedy():
    """
    Methode die nach einem Greedy-Verfahren die Lösungskandidaten auswählt:
    immer der erste Kandidat wird genommen.
    """
    # ToDo



def LösungskandidatenAuswählenBacktracking():
    """
    LösungskandidatenAuswählenBacktracking
    startet die Lösung mit dem Aufruf der rekursiven Methode mit dem Index 0
    und gibt danach die Lösung aus.
    """
    # ToDo


def DatenEinlesen(rätselnummer: int):
    """
    Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei, 
    liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
    die Felder wörter bzw. wortlücken
    Falls eine falsche Nummer eingegeben wird, bricht das Programm nicht ab, sondern initialisiert leere Listen.

    @param rätselnummer Eine Nummer zwischen 0 und 5 
    """
    global wortlücken, wörter

    if 0 <= rätselnummer <= 5:
        dateiname = f"raetsel{rätselnummer}.txt"
        try:
            with open(dateiname, "r", encoding="utf-8") as f:
                dateiinhalt = [line.rstrip("\n") for line in f]
        except FileNotFoundError as e:
            print("Datei nicht gefunden: " + str(e))
            wortlücken = []
            wörter = []
            return

        lückentext = dateiinhalt[0] if dateiinhalt else ""
        wörterAlsZeichenkette = dateiinhalt[1] if len(dateiinhalt) > 1 else ""

        print("Fülle den Lückentext ")
        print(lückentext)
        print("mit folgenden Wörtern ")
        print(wörterAlsZeichenkette)

        # str.split() verwenden; falls die Zeile komplett leer ist, [''] behalten (ähnlich Original)
        wortlücken = lückentext.split() if lückentext.strip() else ['']
        wörter = wörterAlsZeichenkette.split() if wörterAlsZeichenkette.strip() else ['']
    else:
        print(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!")
        wortlücken = []
        wörter = []


def FelderErzeugenUndInitialisieren():
    """
    Methode FelderErzeugenUndInitialisieren erzeugt und initialisiert die 
    Attribute (Felder), welche während der Berechnung benötigt werden.
    """
    global wortkandidatenFürLücken, wortVerwendet, wortzuordnungFürIndizesLücken, wortzuordnungFürIndizesLückenFinal, wortlückenErgebnis, wortlücken, wörter

    # Feld wortkandidatenFürLücken erzeugen und bei jedem Feldelement ein int Feld mit einem einzigen Element -1 hinzufügen
    wortkandidatenFürLücken = []
    for _ in range(len(wortlücken)):
        wortkandidatenFürLücken.append([-1])

    # Feld erzeugen und vorbelegen mit false (Größe anhand der Anzahl Wörter)
    wortVerwendet = [False] * len(wörter)

    wortzuordnungFürIndizesLücken = [-1] * len(wortlücken)
    wortzuordnungFürIndizesLückenFinal = []

    # Achtung: Kopie, nicht Referenz
    wortlückenErgebnis = list(wortlücken)

    # Set globals to the local names
    globals()['wortkandidatenFürLücken'] = wortkandidatenFürLücken
    globals()['wortVerwendet'] = wortVerwendet
    globals()['wortzuordnungFürIndizesLücken'] = wortzuordnungFürIndizesLücken
    globals()['wortzuordnungFürIndizesLückenFinal'] = wortzuordnungFürIndizesLückenFinal
    globals()['wortlückenErgebnis'] = wortlückenErgebnis



if __name__ == "__main__":
    # Beispiel: Rätsel 0 lösen
    DatenEinlesen(0)
    FelderErzeugenUndInitialisieren()
    WortkandidatenBestimmen()

 
