from typing import List

class LottasWortraetselLoeser:
    """
    Wörträtsel (Lösung zu 39. BWINf Runde 1 Aufgabe 1)

    author: Peter Brichzin
    version: 18.8.25
    """
    def __init__(self, rätselnummer: int):
        """
        Worträtsel Konstruktor:
        - liest die Daten ein
        - erzeugt und initialisiert die Felder, die zur Berechnung nötig sind
        - startet den Lösungsprozess
        - gibt das Ergebnis aus

        @param rätselnummer Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
        """

        # zu verteilende Wörter als Feld
        self.wörter: List[str] = []

        # Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten
        self.wortlücken: List[str] = []

        # Lücken für die Wörter, die im Idealfall nur noch Buchstaben und Satzzeichen,
        # aber keine den Plätzen für Buchstaben (gekennzeichnet durch "_") enthalten.
        self.wortlückenErgebnis: List[str] = []

        # für jede Lücke die Indizes der Wörter die passen
        self.wortkandidatenFürLücken: List[List[int]] = []

 
        # Daten einlesen und Felder initialisieren
        self.DatenEinlesen(rätselnummer)
        self.FelderErzeugenUndInitialisieren()

       

    def WortkandidatenBestimmen(self):
        """
        Für jede Lücke (Liste wortlücken) werden die Wörter (Liste Wörter)
        bestimmt, die in die Lücke passen. Gespeichert werden zu jedem Index der
        Liste wortlücken alle Indizes (der Liste Wörter) passender Wörter.
       - nur bei gleicher Länge zeichenweise mit gegebenen Buchstaben bzw. dem Unterstrich als Zeichen für die Lücke verglichen.
        """
        # ToDo

    def LösungskandidatenAuswählenGreedy(self):
        """
        Methode die nach einem Greedy-Verfahren die Lösungskandidaten auswählt:
        immer der erste Kandidat wird genommen.
        """
        # ToDo

    def LösungskandidatenAuswählenBacktracking(self):
        """
        LösungskandidatenAuswählenBacktracking
        startet die Lösung mit dem Aufruf der rekursiven Methode mit dem Index 0
        und gibt danach die Lösung aus.
        """
        # ToDo


    def DatenEinlesen(self, rätselnummer: int):
        """
        Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei,
        liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
        die Felder wörter bzw. wortlücken
        Falls eine falsche Nummer eingegeben wird, bricht das Programm nicht ab, sondern initialisiert leere Listen.

        @param rätselnummer Eine Nummer zwischen 0 und 5
        """
        if 0 <= rätselnummer <= 5:
            dateiname = f"raetsel{rätselnummer}.txt"
            try:
                with open(dateiname, "r", encoding="utf-8") as f:
                    dateiinhalt = [line.rstrip("\n") for line in f]
            except FileNotFoundError as e:
                print("Datei nicht gefunden: " + str(e))
                self.wortlücken = []
                self.wörter = []
                return

            lückentext = dateiinhalt[0] if dateiinhalt else ""
            wörterAlsZeichenkette = dateiinhalt[1] if len(dateiinhalt) > 1 else ""

            print("Fülle den Lückentext ")
            print(lückentext)
            print("mit folgenden Wörtern ")
            print(wörterAlsZeichenkette)

            # str.split() verwenden; falls die Zeile komplett leer ist, [''] behalten (ähnlich Original)
            self.wortlücken = lückentext.split() if lückentext.strip() else ['']
            self.wörter = wörterAlsZeichenkette.split() if wörterAlsZeichenkette.strip() else ['']
        else:
            print(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!")
            self.wortlücken = []
            self.wörter = []

    def FelderErzeugenUndInitialisieren(self):
        """
        Methode FelderErzeugenUndInitialisieren erzeugt und initialisiert die
        Attribute (Felder), welche während der Berechnung benötigt werden.
        """
        # Feld wortkandidatenFürLücken erzeugen und bei jedem Feldelement ein int Feld mit einem einzigen Element -1 hinzufügen
        self.wortkandidatenFürLücken = []
        for _ in range(len(self.wortlücken)):
            self.wortkandidatenFürLücken.append([-1])

        # Feld erzeugen und vorbelegen mit false (Größe anhand der Anzahl Wörter)
        self.wortVerwendet = [False] * len(self.wörter)

        self.wortzuordnungFürIndizesLücken = [-1] * len(self.wortlücken)
        self.wortzuordnungFürIndizesLückenFinal = []

        # Achtung: Kopie, nicht Referenz
        self.wortlückenErgebnis = list(self.wortlücken)


if __name__ == "__main__":
    löser = LottasWortraetselLoeser(0)
