from typing import List

class MaximaleTeilsumme:
    """Die Klasse löst das Teilsummenproblem (maximale zusammenhängende Teilfolge)
    mit einem teilenden (Divide-and-Conquer) Ansatz wie im Java-Original.
    """
    def __init__(self):
        # Die auszuwertenden Daten (wie im Original)
        self.daten: List[int] = [3, -2, 1, -3, 2, 4, -1, 2]

    def MaximaleSummeEinerTeilfolgeFinden(self, daten: List[int], startIndex: int, endIndex: int) -> int:
        """
        Berechnet die maximale Summe einer zusammenhängenden Teilfolge
        mit geteilter Rekursion .
        @param daten Zahlenliste
        @param startIndex der Startindex (inklusive)
        @param endIndex der Endindex (inklusive)
        @return maximale Summe
        """
        #ToDo
        return -1

    def MaximaleTeilsummeGesundheitsdatenTesten(self):
        """Startet die Berechnung der maximalen Teilsumme und gibt das Ergebnis aus"""
        print("Maximale Teilsumme: " +
              str(self.MaximaleSummeEinerTeilfolgeFinden(self.daten, 0, len(self.daten) - 1)))

    def DatenEinlesen(self, dateiname: str):
        """
        Liest Daten (pro Zeile eine ganze Zahl) aus einer Textdatei aus und speichert sie in self.daten
        @param dateiname Name der Datei mit den Daten
        """
        reader = TextFileReader(dateiname)
        self.daten = reader.DatenAuslesen()
        print(f"{len(self.daten)} Daten eingelesen.")


class TextFileReader:
    """TextFileReader liest eine Textdatei mit ganzen Zahlen ein und stellt diese über DatenAuslesen zur Verfügung."""
    def __init__(self, dateiname: str):
        self.daten: List[int] = []
        try:
            with open(dateiname, "r", encoding="utf-8") as f:
                for line in f:
                    line_stripped = line.rstrip("\n")
                    print(line_stripped)
                    try:
                        zahl = int(line_stripped.strip())
                        self.daten.append(zahl)
                    except ValueError:
                        print("Ungültige Zahl in Zeile: " + line_stripped)
        except FileNotFoundError as e:
            print("Datei nicht gefunden: " + str(e))

    def DatenAuslesen(self) -> List[int]:
        return self.daten


if __name__ == "__main__":
    mt = MaximaleTeilsumme()
    mt.MaximaleTeilsummeGesundheitsdatenTesten()
    # Beispiel zum Einlesen aus Datei:
    # mt.DatenEinlesen("daten1.csv")
    # mt.MaximaleTeilsummeGesundheitsdatenTesten()
