import Foundation

/**
Ermittelt den Zeitbedarf, um alle Passwörter gegebener Länge und mit gegebenem Zeichenvorrat durchzuprobieren

- author: Albert Wiedemann
- version: 1.0
*/
class Passwörter
{
    /** Das Passwort */
    var passwort: String
    /** Der Zeichenvorrat */
    var zeichen: [Character]
    /** Die Startzeit der Suche */
    var start: Date
    

    /**
    Besetzt die Attribute mit Default-Werten
    */
    init()
    {
        passwort = ""
        zeichen = []
        start = Date()
    }
    
    /**
    Setzt alle Grossbuchstaben als Zeichenvorrat
    */
    private func Alphabet26Setzen()
    {
        zeichen = []
        for ch in "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        {
            zeichen.append(ch)
        }
    }
    
    /**
     Setzt alle Buchstaben als Zeichenvorrat
     */
    private func Alphabet52Setzen()
    {
        zeichen = []
        for ch in "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        {
            zeichen.append(ch)
        }
        for ch in "abcdefghijklmnopqrstuvwxyz"
        {
            zeichen.append(ch)
        }
    }
    
    /**
     * Setzt alle Buchstaben, Ziffern und genügend Sonderzeichen als Zeichenvorrat
     */
    private func Alphabet78Setzen()
    {
        zeichen = []
        for ch in "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
        {
            zeichen.append(ch)
        }
        for ch in "abcdefghijklmnopqrstuvwxyz"
        {
            zeichen.append(ch)
        }
        for ch in "0123456789"
        {
            zeichen.append(ch)
        }
        for ch in "!@#$%^&*()[]{}/"
        {
            zeichen.append(ch)
        }
    }
    
    /**
    Erzeugt ein Passwort gegebener Länge aus dem vorhandenen Zeichenvorrat.
    - parameters:
        - stellenanzahl :Anzahl der Stellen für das Passwort
     */
    private func PasswortErzeugen(stellenanzahl: Int)
    {
        passwort = "";
        for _ in 0 ..< stellenanzahl
        {
            passwort = passwort + String(zeichen[Int.random(in: 0 ..< zeichen.count)])
        }
    }
    
    /**
    Bearbeitet eine Stelle
    - parameters:
        - anfangsFolge: die bisherige Zeichenfolge für den Passworttest
     */
    private func NächsteStelleTesten(anfangsFolge: String)
    {
        for ch in zeichen
        {
            let test = anfangsFolge + String(ch)
            if passwort.count == test.count
            {
                if passwort == test
                {
                    print("Gefunden nach: \(Int(Date().timeIntervalSince(start) * 1000000))µs")
                }
            }
            else
            {
                NächsteStelleTesten(anfangsFolge: test)
            }
        }
    }
    
    /**
    Testet alle Möglichkeiten für das Passwort durch
    - parameters:
        - stellenanzahl: Anzahl der Stellen für das Passwort
        - alphabetlänge: Anzahl der Zeichen im Alphabet, erlaubt sind 26, 52 oder 78 Zeichen
    */
    func PasswortTest(stellenanzahl: Int, alphabetlänge: Int)
    {
        if alphabetlänge == 26
        {
            Alphabet26Setzen()
        }
        else if alphabetlänge == 52
        {
            Alphabet52Setzen()
        }
        else if alphabetlänge == 78
        {
            Alphabet78Setzen();
        }
        else
        {
            print("Falsche Alphabetlänge \(alphabetlänge)")
        }
        PasswortErzeugen(stellenanzahl: stellenanzahl)
        start = Date()
        NächsteStelleTesten(anfangsFolge: "")
        print("Gesamtlaufzeit: \(Int(Date().timeIntervalSince(start) * 1000000))µs")
    }
}

let test = Passwörter()
test.PasswortTest(stellenanzahl: 6, alphabetlänge: 26)
