import UIKit

/**
Generiert zufällige Bezeichner vom Typ String gegebener Länge.

 - author: Albert Wiedemann
- version: 1.0
*/
class Generator
{
    /** Der Zeichenvorrat für die Bezeichner */
    private let zeichen: [Character] = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"]
    /** Die Länge der zu generierenden Bezeichner */
    private var länge: Int

    /**
    Initialisiert den Zufallsgenerator.
    - parameters:
        - länge: Die Länge der zu generierenden Bezeichner
     */
    init(länge: Int)
    {
        self.länge = länge
    }
    
    /**
    erzeugt einen neuen Bezeichner.
    - returns: der neue Bezeichner
    */
    func BezeichnerGenerieren() -> String
    {
        var resultat = ""
        for _ in 1 ... länge
        {
            resultat = resultat + String(zeichen[Int.random(in: 0 ..< zeichen.count)])
        }
        return resultat
    }
}

/**
Führt die gewünschten Laufzeittests durch.

- author: Albert Wiedemann
- version: 1.0
*/
class TestSuche
{
    /** Anzahl der Suchvorgänge für die Durchschnittsbildung */
    private let anzahlSuchvorgänge = 100000
    /** Erzeugerelement für die Schlüsselwerte */
    private var g: Generator
    /** Die vorhandenen Datenelemente unsortiert */
    private var schlüsselwerte: [String]
    /** Die vorhandenen Datenelemente sortiert */
    private var sortierteSchlüsselwerte: [String]

    /**
    Legt die benötigten Objekte an und besetzt die Attributwerte.
    */
    init()
    {
        g = Generator(länge: 10);
        schlüsselwerte = Array<String>()
        sortierteSchlüsselwerte = Array<String>()
    }
    
    /**
    Besetzt die Felder mit der gewünschten Anzahl von Elementen
    - parameters:
        - anzahl: Anzahl der Datenelemente
    */
    private func DatenErzeugen(anzahl: Int)
    {
        schlüsselwerte.removeAll()
        sortierteSchlüsselwerte.removeAll()
        for i in 0 ..< anzahl
        {
            let neu = g.BezeichnerGenerieren()
            schlüsselwerte.append(neu)
            if i == 0
            {
                sortierteSchlüsselwerte.append(neu)
            }
            else
            {
                var pos = i
                while (pos > 0) && (sortierteSchlüsselwerte[pos - 1] > neu)
                {
                    pos -= 1
                }
                sortierteSchlüsselwerte.insert(neu, at: pos)
            }
        }
    }
    
    /**
    Zu suchendes Testelement auswählen.
    - returns: Testelement
     */
    private func TestWählen() -> String
    {
        return schlüsselwerte[Int.random(in: 0 ..< schlüsselwerte.count)]
    }
    
    /**
    Misst die Zeit für einen Suchvorgang im unsortierten Feld.
     
    Um dem Mittelwert nahe zu kommen,wird der Vorgang 'anzahlSuchvorgänge' Mal
    wiederholt und die durchschnittliche Suchzeit ermittelt.
    */
    private func UnsortierteSucheDurchführen()
    {
        var zeit = 0.0
        var zählergesamt = 0
        for _ in 1 ... anzahlSuchvorgänge
        {
            let gesucht = TestWählen()
            let start = Date()
            var pos = 0
            var zähler = 0
            while (pos < schlüsselwerte.count) && schlüsselwerte[pos] != gesucht
            {
                zähler += 1
                pos += 1
            }
            let ende = Date()
            zeit += ende.timeIntervalSince(start)
            zählergesamt += zähler;
        }
        print("\(Int(zeit * 1000000) / anzahlSuchvorgänge)µs, \(zählergesamt / anzahlSuchvorgänge)")
    }
    
    /**
    Misst die Zeit für einen Suchvorgang im sortierten Feld.
     
    Um dem Mittelwert nahe zu kommen,wird der Vorgang 'anzahlSuchvorgänge' Mal
    wiederholt und die durchschnittliche Suchzeit ermittelt.
    */
    private func SortierteSucheDurchführen()
    {
        var zeit = 0.0
        for _ in 1 ... anzahlSuchvorgänge
        {
            let gesucht = TestWählen()
            let start = Date()
            var min = 0
            var max = sortierteSchlüsselwerte.count
            while true
            {
                var mitte = (max + min) / 2
                if sortierteSchlüsselwerte[mitte] == gesucht
                {
                    break
                }
                else if sortierteSchlüsselwerte[mitte] < gesucht
                {
                    min = mitte + 1
                }
                else
                {
                    max = mitte
                }
                if min >= max
                {
                    break
                }
            }
            let ende = Date()
            zeit += ende.timeIntervalSince(start)
        }
        print("\(Int(zeit * 1000000) / anzahlSuchvorgänge)µs");
    }
    
    /**
    Bestimmt die durschnittlichen Suchzeiten.
    - parameters:
        - anzah:l Anzahl der Feldelemente
     */
    func DurchschnittsTest(anzahl: Int)
    {
        DatenErzeugen(anzahl: anzahl)
        print("Suche im unsortierten Feld mit \(anzahl) Elementen: ")
        UnsortierteSucheDurchführen()
        print("Suche im sortierten Feld mit \(anzahl) Elementen: ")
        SortierteSucheDurchführen()
    }
}

let t = TestSuche()
t.DurchschnittsTest(anzahl: 100)
