import UIKit
import PlaygroundSupport

/**
Generiert zufällige Bezeichner vom Typ String gegebener Länge.

 - author: Albert Wiedemann
- version: 1.0
*/
class Generator
{
    /** Der Zeichenvorrat für die Bezeichner */
    private let zeichen: [Character] = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"]
    /** Die Länge der zu generierenden Bezeichner */
    private var länge: Int

    /**
    Initialisiert den Zufallsgenerator.
    - parameters:
        - länge: Die Länge der zu generierenden Bezeichner
     */
    init(länge: Int)
    {
        self.länge = länge
    }
    
    /**
    erzeugt einen neuen Bezeichner.
    - returns: der neue Bezeichner
    */
    func BezeichnerGenerieren() -> String
    {
        var resultat = ""
        for _ in 1 ... länge
        {
            resultat = resultat + String(zeichen[Int.random(in: 0 ..< zeichen.count)])
        }
        return resultat
    }
}

/**
Führt die gewünschten Laufzeittests durch.

- author: Albert Wiedemann
- version: 1.0
*/
class TestSortieren
{
    /** Anzahl der Datenelemente im Feld */
    private var anzahl: Int
    /** Erzeugerelement für die Schlüsselwerte */
    private var g: Generator
    /** Die Ausgangsdaten */
    private var daten: [String]
    /** Die Zähler für die relevanten Operationen */
    // Hier die Attribute ergänzen

    /**
    Legt die benötigten Objekte an und besetzt die Attributwerte.
    - parameters:
        - anzah:l Anzahl der zu sortierenden Datenelemente
    */
    init(anzahl: Int)
    {
        self.anzahl = anzahl
        g = Generator(länge: 10)
        daten = []
        for _ in 0 ..< anzahl
        {
            daten.append(g.BezeichnerGenerieren())
        }
        var d = daten
        SelectionSort(d: &d)
        d = daten
        BubbleSort(d: &d)
        d = daten
        MergeSort(d: &d)
    }

    /**
    Sortiert das gegebene Feld durch Auswahl des jeweils kleinsten Elements im unsortierten Rest.
    - parameters:
        - d: das zu sortierende Feld
     */
    private func SelectionSort(d: inout [String])
    {
        for i in 0 ..< d.count
        {
            var pos = i
            for j in i + 1 ..< d.count
            {
                if d[j] < d[pos]
                {
                    pos = j
                }
            }
            let hilf = d[i]
            d[i] = d[pos]
            d[pos] = hilf
        }
    }

    /**
    Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
    - parameters:
        - d: das zu sortierende Feld
     */
    private func BubbleSort(d: inout [String])
    {
        for i in 0 ..< d.count
        {
            for j in 0 ..< d.count - 1
            {
                if d[j] > d[j + 1]
                {
                    let hilf = d[j]
                    d[j] = d[j + 1]
                    d[j + 1] = hilf
                }
            }
        }
    }

    /**
    Sortiert den angegebenen Teilbereich des Feldes.
    
    pre: beide Felder enthalten die Ausgangsdaten, da der Start nicht vorhersagbar ist.
    - parameters:
        - von: das Feld mit den Ausgangsdaten
        - nach: das Feld mit den Zieldaten
        - minIndex: der Index, ab dem sortiert werden soll
        - topIndex: der Index, bis zu dem (ausschließlich) sortiert werden soll
     */
    private func Mischen(von: inout [String], nach: inout [String], minIndex: Int, topIndex: Int)
    {
        if minIndex < topIndex - 1
        {
            var mitte = (minIndex + topIndex) / 2
            Mischen(von: &nach, nach: &von, minIndex: minIndex, topIndex: mitte)
            Mischen(von: &nach, nach: &von, minIndex: mitte, topIndex: topIndex)
            var posUnten = minIndex
            var posOben = mitte
            var pos = minIndex
            while pos < topIndex
            {
                if posUnten >= mitte
                {
                    while posOben < topIndex
                    {
                        nach[pos] = von[posOben]
                        pos += 1
                        posOben += 1
                    }
                }
                else if posOben >= topIndex
                {
                    while posUnten < mitte
                    {
                        nach[pos] = von[posUnten]
                        pos += 1
                        posUnten += 1
                    }
                }
                else
                {
                    if von[posUnten] <= von[posOben]
                    {
                        nach[pos] = von[posUnten]
                        posUnten += 1
                    }
                    else
                    {
                        nach[pos] = von[posOben]
                        posOben += 1
                    }
                    pos += 1
                }
            }
        }
    }
    
    /**
    Sortiert das gegebene Feld durch Mischen immer längerer Teilfelder.
    - parameters:
        - d: das zu sortierende Feld
     */
    private func MergeSort(d: inout [String])
    {
        var nach = d
        Mischen(von: &d, nach: &nach, minIndex: 0, topIndex: d.count)
        for i in 0 ..< d.count
        {
            d[i] = nach[i]
        }
    }
    
    /**
    Meldet die Anzahl relevanter Operationen für die Sortierung durch direktes Auswählen.
    - returns: Anzahl der Operationen
     */
    func ZählerFürSelectionSortGeben() -> Int
    {
        //Hier Zählerwert ausgeben
        return 0
    }
    
    /**
    Meldet die Anzahl relevanter Operationen für die Sortierung durch Vertauschen falsch stehender Nachbarelemente.
    - returns: Anzahl der Operationen
    */
    func ZählerFürBubbleSortGeben() -> Int
    {
        //Hier Zählerwert ausgeben
        return 0
    }
    
    /**
    Meldet die Anzahl relevanter Operationen für die Sortierung durch Mischen.
    - returns: Anzahl der Operationen
     */
    func ZählerFürMergesortGeben() -> Int
    {
        //Hier Zählerwert ausgeben
        return 0
    }
}

/**
 Verwaltet die Viewklassen
 */
class MyViewController : UIViewController
{
    /** Eingabefeld für die Knotenanzahl */
    let anzahlFeld = UITextField()
    /** Ausgabefeld für den Zähler bei SelectionSort */
    let zählerFeldAuswahl = UILabel()
    /** Ausgabefeld für den Zähler bei BubbleSort */
    let zählerFeldVertauschen = UILabel()
    /** Ausgabefeld für den Zähler bei MergeSort */
    let zählerFeldMischen = UILabel()

    override func viewDidLoad()
    {
        view.backgroundColor = UIColor(red: 0.95, green: 0.95, blue: 0.95, alpha: 1.0)

        let label1 = UILabel()
        label1.text = "Anzahl der zu sortierenden Datenelemente"
        label1.textColor = .black
        label1.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label1)
        let label2 = UILabel()
        label2.text = "Zähler für Sortieren durch Auswählen"
        label2.textColor = .black
        label2.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label2)
        let label3 = UILabel()
        label3.text = "Zähler für Sortieren durch Vertauschen"
        label3.textColor = .black
        label3.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label3)
        let label4 = UILabel()
        label4.text = "Zähler für Sortieren durch Mischen"
        label4.textColor = .black
        label4.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label4)
        anzahlFeld.backgroundColor = .white
        anzahlFeld.placeholder = "Anzahl der Elemente"
        anzahlFeld.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(anzahlFeld)
        zählerFeldAuswahl.text = "---"
        zählerFeldAuswahl.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(zählerFeldAuswahl)
        zählerFeldVertauschen.text = "---"
        zählerFeldVertauschen.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(zählerFeldVertauschen)
        zählerFeldMischen.text = "---"
        zählerFeldMischen.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(zählerFeldMischen)
        let test = UIButton(type: .system)
        test.setTitle("Test ausführen", for: .normal)
        test.layer.cornerRadius = 10
        test.backgroundColor = .white
        test.addTarget(self, action: #selector(Ausführen), for: .touchUpInside)
        test.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(test)

        NSLayoutConstraint.activate([
            label1.topAnchor.constraint(equalTo: view.topAnchor, constant: 16),
            label1.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label1.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            label2.topAnchor.constraint(equalTo: label1.bottomAnchor, constant: 16),
            label2.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label2.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            label3.topAnchor.constraint(equalTo: label2.bottomAnchor, constant: 16),
            label3.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label3.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            label4.topAnchor.constraint(equalTo: label3.bottomAnchor, constant: 16),
            label4.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label4.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            anzahlFeld.leadingAnchor.constraint(equalTo: label1.trailingAnchor),
            anzahlFeld.centerYAnchor.constraint(equalTo: label1.centerYAnchor),
            zählerFeldAuswahl.leadingAnchor.constraint(equalTo: label2.trailingAnchor),
            zählerFeldAuswahl.centerYAnchor.constraint(equalTo: label2.centerYAnchor),
            zählerFeldVertauschen.leadingAnchor.constraint(equalTo: label3.trailingAnchor),
            zählerFeldVertauschen.centerYAnchor.constraint(equalTo: label3.centerYAnchor),
            zählerFeldMischen.leadingAnchor.constraint(equalTo: label4.trailingAnchor),
            zählerFeldMischen.centerYAnchor.constraint(equalTo: label4.centerYAnchor),
            test.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 266),
            test.topAnchor.constraint(equalTo: label4.bottomAnchor, constant: 16),
            test.widthAnchor.constraint(greaterThanOrEqualToConstant: 200)
        ])
    }
    
    /**
     Aktionsmethode für den Ausführen-Knopf
     */
    @objc func Ausführen()
    {
        zählerFeldAuswahl.text = "---"
        zählerFeldVertauschen.text = "---"
        zählerFeldMischen.text = "---"
        if let anzahl = Int(anzahlFeld.text!)
        {
            let test = TestSortieren(anzahl: anzahl)
            zählerFeldAuswahl.text = "\(test.ZählerFürSelectionSortGeben())"
            zählerFeldVertauschen.text = "\(test.ZählerFürBubbleSortGeben())"
            zählerFeldMischen.text = "\(test.ZählerFürMergesortGeben())"
        }
        else
        {
            anzahlFeld.text = "Falsche Eingabe"
        }
    }
}
// Present the view controller in the Live View window
PlaygroundPage.current.liveView = MyViewController()


