import UIKit
import PlaygroundSupport

/**
Generiert zufällige Bezeichner vom Typ String gegebener Länge.

 - author: Albert Wiedemann
- version: 1.0
*/
class Generator
{
    /** Der Zeichenvorrat für die Bezeichner */
    private let zeichen: [Character] = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j"]
    /** Die Länge der zu generierenden Bezeichner */
    private var länge: Int

    /**
    Initialisiert den Zufallsgenerator.
    - parameters:
        - länge: Die Länge der zu generierenden Bezeichner
     */
    init(länge: Int)
    {
        self.länge = länge
    }
    
    /**
    erzeugt einen neuen Bezeichner.
    - returns: der neue Bezeichner
    */
    func BezeichnerGenerieren() -> String
    {
        var resultat = ""
        for _ in 1 ... länge
        {
            resultat = resultat + String(zeichen[Int.random(in: 0 ..< zeichen.count)])
        }
        return resultat
    }
}

/**
Führt die gewünschten Laufzeittests durch.

- author: Albert Wiedemann
- version: 1.0
*/
class TestSortieren
{
    /** Anzahl der Datenelemente im Feld */
    private var anzahl: Int
    /** Erzeugerelement für die Schlüsselwerte */
    private var g: Generator
    /** Die Ausgangsdaten */
    private var daten: [String]
    /** Die Zähler für die relevanten Operationen */
    private var zählerBubble, zählerShaker: Int

    /**
    Legt die benötigten Objekte an und besetzt die Attributwerte.
    - parameters:
        - anzah:l Anzahl der zu sortierenden Datenelemente
    */
    init(anzahl: Int)
    {
        self.anzahl = anzahl
        g = Generator(länge: 10)
        daten = []
        for _ in 0 ..< anzahl
        {
            daten.append(g.BezeichnerGenerieren())
        }
        zählerBubble = 0
        zählerShaker = 0
        var d = daten
        BubbleSort(d: &d)
        d = daten
        ShakerSort(d: &d)
    }

    /**
    Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente.
    - parameters:
        - d: das zu sortierende Feld
     */
    private func BubbleSort(d: inout [String])
    {
        for i in 0 ..< d.count
        {
            for j in 0 ..< d.count - 1
            {
                zählerBubble += 1
                if d[j] > d[j + 1]
                {
                    let hilf = d[j]
                    d[j] = d[j + 1]
                    d[j + 1] = hilf
                }
            }
        }
    }
    
    /**
    Sortiert das gegebene Feld durch Vertauschen falsch stehender Nachbarelemente im Hin- und Rücklauf.
    - parameters:
        - d: das zu sortierende Feld
     */
    private func ShakerSort(d: inout [String])
    {
    }
    
    /**
    Meldet die Anzahl relevanter Operationen für die Sortierung durch Vertauschen falsch stehender Nachbarelemente.
    - returns: Anzahl der Operationen
    */
    func ZählerFürBubbleSortGeben() -> Int
    {
        return zählerBubble
    }
    
    /**
    Meldet die Anzahl relevanter Operationen für die Sortierung durch Mischen.
    - returns: Anzahl der Operationen
     */
    func ZählerFürShakerSortGeben() -> Int
    {
        return zählerShaker
    }
}

/**
 Verwaltet die Viewklassen
 */
class MyViewController : UIViewController
{
    /** Eingabefeld für die Knotenanzahl */
    let anzahlFeld = UITextField()
    /** Ausgabefeld für den Zähler bei BubbleSort */
    let zählerFeldVertauschen = UILabel()
    /** Ausgabefeld für den Zähler bei Shaker */
    let zählerFeldVertauschenPlus = UILabel()

    override func viewDidLoad()
    {
        view.backgroundColor = UIColor(red: 0.95, green: 0.95, blue: 0.95, alpha: 1.0)

        let label1 = UILabel()
        label1.text = "Anzahl der zu sortierenden Datenelemente"
        label1.textColor = .black
        label1.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label1)
        let label2 = UILabel()
        label2.text = "Zähler für Sortieren durch BubbleSort"
        label2.textColor = .black
        label2.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label2)
        let label3 = UILabel()
        label3.text = "Zähler für Sortieren durch ShakerSort"
        label3.textColor = .black
        label3.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(label3)
        anzahlFeld.backgroundColor = .white
        anzahlFeld.placeholder = "Anzahl der Elemente"
        anzahlFeld.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(anzahlFeld)
        zählerFeldVertauschen.text = "---"
        zählerFeldVertauschen.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(zählerFeldVertauschen)
        zählerFeldVertauschenPlus.text = "---"
        zählerFeldVertauschenPlus.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(zählerFeldVertauschenPlus)
        let test = UIButton(type: .system)
        test.setTitle("Test ausführen", for: .normal)
        test.layer.cornerRadius = 10
        test.backgroundColor = .white
        test.addTarget(self, action: #selector(Ausführen), for: .touchUpInside)
        test.translatesAutoresizingMaskIntoConstraints = false
        view.addSubview(test)

        NSLayoutConstraint.activate([
            label1.topAnchor.constraint(equalTo: view.topAnchor, constant: 16),
            label1.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label1.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            label2.topAnchor.constraint(equalTo: label1.bottomAnchor, constant: 16),
            label2.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label2.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            label3.topAnchor.constraint(equalTo: label2.bottomAnchor, constant: 16),
            label3.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 16),
            label3.widthAnchor.constraint(greaterThanOrEqualToConstant: 350),
            anzahlFeld.leadingAnchor.constraint(equalTo: label1.trailingAnchor),
            anzahlFeld.centerYAnchor.constraint(equalTo: label1.centerYAnchor),
            zählerFeldVertauschen.leadingAnchor.constraint(equalTo: label2.trailingAnchor),
            zählerFeldVertauschen.centerYAnchor.constraint(equalTo: label2.centerYAnchor),
            zählerFeldVertauschenPlus.leadingAnchor.constraint(equalTo: label3.trailingAnchor),
            zählerFeldVertauschenPlus.centerYAnchor.constraint(equalTo: label3.centerYAnchor),
            test.leadingAnchor.constraint(equalTo: view.leadingAnchor, constant: 266),
            test.topAnchor.constraint(equalTo: label3.bottomAnchor, constant: 16),
            test.widthAnchor.constraint(greaterThanOrEqualToConstant: 200)
        ])
    }
    
    /**
     Aktionsmethode für den Ausführen-Knopf
     */
    @objc func Ausführen()
    {
        zählerFeldVertauschen.text = "---"
        zählerFeldVertauschenPlus.text = "---"
        if let anzahl = Int(anzahlFeld.text!)
        {
            let test = TestSortieren(anzahl: anzahl)
            zählerFeldVertauschen.text = "\(test.ZählerFürBubbleSortGeben())"
            zählerFeldVertauschenPlus.text = "\(test.ZählerFürShakerSortGeben())"
        }
        else
        {
            anzahlFeld.text = "Falsche Eingabe"
        }
    }
}
// Present the view controller in the Live View window
PlaygroundPage.current.liveView = MyViewController()


