import Foundation

/**
TextFileReader liest die Textdateien mit den Rätseln und stellt über die
Methoden den Lückentext bzw. die Wörter als Zeichenketten zur Verfügung.
 *
 * @author (Peter Brichzin)
 * @version (11.11.24)
 */
class TextFileReader
{
    /** Der Inhalt der Datei zeilenweise */
    private var dateiinhalt: [String]

    /**
    TextFileReader Liest die Daten des Beispiels der Einstiegsaufgabe ein.
     */
    convenience init()
    {
        self.init(dateiname: "raetsel0.txt")
    }
    
    /**
    TextFileReader liest die Daten der angegebenen Textdatei ein.
    - parameters:
         - dateiname: Dateiname "raetsel0.txt" bis "raetsel5.txt" ist möglich
     */
    init(dateiname: String)
    {
        do
        {
            dateiinhalt = try String(contentsOf: Bundle.main.url(forResource: dateiname, withExtension: "")!, encoding: String.Encoding.utf8).split(separator: "\n").map(String.init)
        }
        catch
        {
            print("Fehler beim Lesen der Datei: \(error)")
            dateiinhalt = []
        }
    }
    
    /**
    Gibt den Lückentext als Zeichenkette zurück.
    - returns: der Lückentext
     */
    func LückentextGeben() -> String
    {
        return dateiinhalt[0]
    }
    
    /**
     Gibt die Wörter als Zeichenkette zurück.
    - returns: die Wörter
     */
    func WörterAlsZeichenketteGeben() -> String
    {
        return dateiinhalt[1]
    }
}

/**
Wörträtsel (Lösung zu 39. BWINf Runde 1 Aufgabe 1)

- author: Peter Brichzin
- version: 6.1.25
 */
class LottasWorträtselLöser
{
    /** zu verteilende Wörter als Feld */
    private var wörter: [String] = []

    /** Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten */
    private var wortlücken: [String] = []

    /** Lücken für die Wörter, die im Idealfall nur noch Buchstaben und Satzzeichen,
     * aber keine Plätze für Buchstaben (gekennzeichnet durch "_") enthalten */
    private var wortlückenErgebnis: [String] = []

    /** für jede Lücke die Indizes der Wörter die passen */
    private var wortkandidatenFürLücken: [[Int]] = []

    /**
    Worträtsel Konstruktor:
    * liest die Daten ein
    * erzeugt und initialisiert die Felder, die zur Berechnung nötig sind
    * startet den Lösungsprozess
    * gibt das Ergebnis aus
    - parameters:
        - rätselnummer: Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
     */
    init(rätselnummer: Int)
    {
        // Daten einlesen und damit die Felder wörter und wortlücken initialisieren
        DatenEinlesen(rätselnummer: rätselnummer)

        FelderErzeugenUndInitialisieren()

    }

    /**
    Für jede Lücke (Liste wortlücken) werden die Wörter (Liste Wörter)
    bestimmt, die in die Lücke passen. Gespeichert werden zu jedem Index der
    Liste wortlücken alle Indizes (der Liste Wörter) passender Wörter.
     */
    func WortkandidatenBestimmen()
    {
        //ToDo
    }

    /**
    Methode die nach einem Greedy-Verfahren die Lösungskandidaten auswählt.
     */
    func LösungskandidatenAuswählenGreedy()
    {
        //ToDo
    }

    /**
    Methode die nach einem Backtracking-Verfahren die Lösungskandidaten auswählt.
     */
    func LösungskandidatenAuswählenBacktracking()
    {
        //ToDo
    }

    /**
    Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei,
    liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
    die Felder wörter bzw. wortlücken
    Falls eine falsche Nummer eingegeben wird, bricht das Programm mit einer Ausnahmesituation ab.
    - parameters:
         - rätselnummer: Eine Nummer zwischen 0 und 5
     */
    func DatenEinlesen(rätselnummer: Int)
    {
        // Textdatei auswählen und öffen
        if rätselnummer >= 0 && rätselnummer <= 5
        {
            let dateiname = "raetsel\(rätselnummer).txt"
            let reader = TextFileReader(dateiname: dateiname)

            // Daten auslesen
            /** Lückentext  */
            let lückentext = reader.LückentextGeben()

            /** einzusetzende Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt */
            let wörterAlsZeichenkette = reader.WörterAlsZeichenketteGeben()

            // Rätsel auf Konsole ausgeben
            print("Fülle den Lückentext ")
            print(lückentext)
            print("mit folgenden Wörtern ")
            print(wörterAlsZeichenkette)

            // Daten in Feldern speichern
            wortlücken = ZeichenketteTeilen(zeichenkette: lückentext);
            wörter = ZeichenketteTeilen(zeichenkette: wörterAlsZeichenkette);
        }
        else
        {
            print(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!");
            wortlücken = []
            wörter = []
        }
    }

    /**
    Methode FelderErzeugenUndInitialisieren erzeugt und initialisiert die
    Attribute (Felder), welche während der Berechnung benötigt werden.
     */
    private func FelderErzeugenUndInitialisieren()
    {
        // Feld wortkandidatenFürLücken erzeugen und
        // bei jedem Feldelement ein int Feld mit einem einzigen Element -1 hinzufügen als Zeichen,
        // dass noch kein Wortkandidat für die entsprechende Lücke gefunden wurde.
        wortkandidatenFürLücken = []
        for i in 0 ..< wortlücken.count
        {
            wortkandidatenFürLücken.append([-1])
        }

        wortlückenErgebnis = wortlücken //Swift erstellt dabei eine Kopie des Originals
    }

    /**
    Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste speichern
    - parameters:
         - zeichenkette:  zu teilende Zeichenkette
    - returns: Liste mit Wörtern
     */
    private func ZeichenketteTeilen(zeichenkette: String) -> [String]
    {
        var wörter: [String] = []

        var s = ""
        for ch in zeichenkette
        {
            if ch == " "
            {
                wörter.append(s)
                s = ""
            }
            else
            {
                s = s + String(ch)
            }
        }
        wörter.append(s) //Sollten die Zeichenkette leer sein, würde eine leere Zeichenkette gespeichert werden

        return  wörter
    }
}

/**
Lösung zu 39. BWINf Runde 1 Aufgabe 1 über BruteForce:
Alle möglichen Wortkombinationen werden durch die Permutationen bestimmt.
Der Ansatz funktioniert nur mit dem ersten Text,
die weiteren haben ein Speicherproblem (Heap)

- author: Peter Brichzin
- version: 11.11.24
 */
class BruteForceWorträtselLöser
{
    /** zu verteilende Wörter als Feld */
    var wörter: [String] = []

    /** Lücken für die Wörter, die neben einzelnenen Buchstaben, den Plätzen für Buchstaben (gekennzeichnet durch "_") auch Satzzeichen enthalten */
    var wortlückeMitBuchstabenplatzhalter: [String] = []

    /** Feld für das Endergebnis: zur Lücke passendes Wort (ohne Platzhalter "_" für fehlende Buchstaben)  */
    var wortlückeOhneBuchstabenplatzhalter: [String] = []

    /** Felder zur Bestimmung Speicherung der Permutationen (Brute Force) */
    var teilergebnisPermutation: [String] = []
    var ergebnisPermutation: [[String]] = []

    /**
    Worträtsel Konstruktor:
    liest die Daten ein
    Zum Start der Lösung muss noch die Methode LösenMitBruteForce aufgerufen werden.
    - parameters:
         - rätselnummer: Ziffer zwischen 0 und 5, die das zu lösende Rätsel festlegt
     */
    init(rätselnummer: Int)
    {
        // Daten einlesen und damit die Felder wörter und wortlückeMitBuchstabenplatzhalter initialisieren
        DatenEinlesen(rätselnummer: rätselnummer)

        // wortlückeOhneBuchstabenplatzhalter wird initialisiert mit einer Kopie von wortlückeMitBuchstabenplatzhalter
        // -> an späterer Stelle kann verglichen werden, ob Satzzeichen wieder ergänzt werden müssen
        wortlückeOhneBuchstabenplatzhalter = []
        wortlückeOhneBuchstabenplatzhalter.append(contentsOf: wortlückeMitBuchstabenplatzhalter)

    }

    /**
    Ermittelt  die Lösung des Worträtsels
     */
    func LösenMitBruteForce()
    {
        // Felder zur Speicherung der Permutationen erzeugen
        teilergebnisPermutation = []
        ergebnisPermutation = []
        PermutationWörterBestimmen()
        //print("Anzahl der Permutationen \(ergebnisPermutation.count)")
        PermutationenÜberprüfen()
    }

    /**
    Methode PermutationWörterBestimmen bestimmt alle Permutationen der Wörter
    im Attribut wörter und speichert diese im Attribut ergebnisPermutaion.
     */
    func PermutationWörterBestimmen()
    {
        if wörter.count == 1                     //Rekursionsende: nur ein Wort in der Menge
        {
            teilergebnisPermutation.append(wörter[0])             //letztes Wort wird zum Teilergebnis hinzugefügt
            ergebnisPermutation.append(teilergebnisPermutation) //Teilergebnis ist fertig -> wird in globalem Attribut gespeichert (als neue Liste)
            // print(teilergebnisPermutation)   // mögliche Ausgabe der Permutation, welche aber den Programmablauf verlangsamt.
            teilergebnisPermutation.remove(at: teilergebnisPermutation.count - 1)  //Teilergebnis wird reduziert um das letzte Wort
        }
        else
        {
            //Rekursionsschritt für alle Wörter die in der Wortmenge enthalten sind:
            // ein Wort wird genommen und über "teilergebnis" konkateniert mit allen Permutationen der restlichen Wörter
            for i in 0 ..< wörter.count
            {
                //entsprechend dem Index wird das aktuelle Wort dem Teilergebnis hinzugefügt und aus der Wortliste entfernt
                let aktuellesWort = wörter[i]
                teilergebnisPermutation.append(aktuellesWort)
                wörter.remove(at: i)
                //rekursiver Aufruf (mit Kopie der aktuellen Wortliste)
                PermutationWörterBestimmen()
                //Umkehrung der Schritte vor dem rekursiven Aufruf
                //aktuelles Wort wird vom Teilergebnis weggenommen und der Wortliste hinzugefügt
                wörter.insert(aktuellesWort, at: i)
                teilergebnisPermutation.remove(at: teilergebnisPermutation.count-1)
            }
        }
    }

    /**
    Methode PermutationenÜberprüfen überprüft, ob eine der Permutationen in die Wortfolge mit Lücken passt
    und gibt diese gegebenenfalls aus.
     */
    func PermutationenÜberprüfen()
    {
        var wortlückeOhneSatzzeichen = ""
        var satzzeichen = ""

        var anzahlPassendeWorte = 0

        for p in ergebnisPermutation
        {
            wortlückeOhneBuchstabenplatzhalter.removeAll()
            wortlückeOhneBuchstabenplatzhalter.append(contentsOf: wortlückeMitBuchstabenplatzhalter)
            anzahlPassendeWorte = 0

            for j in 0 ..< p.count
            {
                var wortkandidat = p[j]
                var wortlücke = wortlückeOhneBuchstabenplatzhalter[j]

                //Eliminierung der Satzzeichen
                if wortlücke.last! == "," || wortlücke.last! == "." || wortlücke.last! == "?" || wortlücke.last! == ";" || wortlücke.last! == "!"
                {
                    satzzeichen = String(wortlücke.last!)
                    wortlückeOhneSatzzeichen = String(wortlücke.prefix(wortlücke.count - 1))
                }
                else
                {
                    wortlückeOhneSatzzeichen = wortlücke
                    satzzeichen = ""
                }

                //eigentlicher Vergleich
                var wortPasstInLücke = false
                if wortkandidat.count == wortlückeOhneSatzzeichen.count
                {
                    wortPasstInLücke = true
                    var index = wortlückeOhneSatzzeichen.startIndex
                    for ch in wortkandidat
                    {
                        if !(wortlückeOhneSatzzeichen[index] == ch || wortlückeOhneSatzzeichen[index] == "_")
                        {
                            wortPasstInLücke = false;
                        }
                        index = wortlückeOhneSatzzeichen.index(after: index)
                    }
                }

                //Übernahme als Ergebnis falls der Vergleich erfolgreich, ende dieser Wiederholungsanweisung sonst
                if wortPasstInLücke
                {
                    wortlückeOhneBuchstabenplatzhalter[j] = wortkandidat + satzzeichen
                    anzahlPassendeWorte = anzahlPassendeWorte + 1

                }
                else
                {
                    break
                }

            }
            if anzahlPassendeWorte == wortlückeOhneBuchstabenplatzhalter.count
            {
                print("Ergebnis gefunden :-)")
                break
            }
        }
        print(wortlückeOhneBuchstabenplatzhalter)
        print("und als Satz")

        ErgebnisAusgeben()
    }

 
    /**
     * Teilt Zeichenkette mit Leerzeichen als Trennzeichen in Wörter und speichert diese in einer Liste speichern
     *
     * @param  zeichenkette     zu teilende Zeichenkette
     * @return                  Liste mit Wörtern
     */
    private func ZeichenketteTeilen(zeichenkette: String) -> [String]
    {
        var wörter: [String] = []

        var s = ""
        for ch in zeichenkette
        {
            if ch == " "
            {
                wörter.append(s)
                s = ""
            }
            else
            {
                s = s + String(ch)
            }
        }
        wörter.append(s) //Sollten die Zeichenkette leer sein, würde eine leere Zeichenkette gespeichert werden

        for wort in wörter
        {
            print(wort)
        }

        return  wörter
    }

    /**
    Gibt das Ergebnis der Lösungssuchge auf Konsole aus
     */
    func ErgebnisAusgeben()
    {
        var ergebnis = ""
        for s in wortlückeOhneBuchstabenplatzhalter
        {
            ergebnis = ergebnis + s + " "
        }
        print(ergebnis)
    }

    /**
    Methode DatenEinlesen öffnet abhängig von der Rätselnummer die passende Textdatei,
    liest die zwei Zeichenketten mit den Wörtern bzw. Wortlücken ein, trennt diese bei den Leerzeichen und füllt
    die Felder wörter bzw. wortlücken
    Falls eine falsche Nummer eingegeben wird, bricht das Programm mit einer Ausnahmesituation ab.
    - parameters:
         - rätselnummer: Eine Nummer zwischen 0 und 5
     */
    func DatenEinlesen(rätselnummer: Int)
    {
        // Textdatei auswählen und öffen
        if rätselnummer >= 0 && rätselnummer <= 5
        {
            let dateiname = "raetsel\(rätselnummer).txt"
            let reader = TextFileReader(dateiname: dateiname)

            // Daten auslesen
            /** Lückentext  */
            let lückentext = reader.LückentextGeben()

            /** einzusetzende Wörter als eine einzige Zeichenkette mit Leerzeichen getrennt */
            let wörterAlsZeichenkette = reader.WörterAlsZeichenketteGeben()

            // Rätsel auf Konsole ausgeben
            print("Fülle den Lückentext ")
            print(lückentext)
            print("mit folgenden Wörtern ")
            print(wörterAlsZeichenkette)

            // Daten in Feldern speichern
            wortlückeMitBuchstabenplatzhalter = ZeichenketteTeilen(zeichenkette: lückentext);
            wörter = ZeichenketteTeilen(zeichenkette: wörterAlsZeichenkette);
        }
        else
        {
            print(" Es sind nur Rätselnummern zwischen 0 und 5 erlaubt!!");
            wortlückeMitBuchstabenplatzhalter = []
            wörter = []
        }
    }
}


let b = BruteForceWorträtselLöser(rätselnummer: 0)
b.LösenMitBruteForce()


