import Foundation

/**
TextFileReader liest eine Textdatei mit ganzen Zahlen aus und und stellt diese über die
Methode DatenAuslesen als Zahlenfeld zur Verfügung.

- author: Peter Brichzin
- version: 11.11.24
 */
class TextFileReader
{
    /** Fald der zur Verfügung gestellten Daten */
    var daten: [Int]
    
    /**
     TextFileReader Liest die Daten der angegebenen Textdatei ein.
     - parameters:
     - dateiname: Dateiname
     */
    init(dateiname: String)
    {
        daten = []
        do
        {
            let dateiinhalt = try String(contentsOf: Bundle.main.url(forResource: dateiname, withExtension: "")!, encoding: String.Encoding.utf8).split(separator: "\r\n").map(String.init)
            for zeile in dateiinhalt
            {
                if let zahl = Int(zeile)
                {
                    daten.append(zahl)
                }
                else
                {
                    print("Ungültige Zahl: '" + zeile + "' in Zeile \(daten.count)")
                }
            }
        }
        catch
        {
            print("Fehler beim Lesen der Datei: \(error)")
        }
    }
    
    /**
    Gibt den Dateieinhalt zurück
     - returns: Dateiinhalt als Feld von Zahlen
     */
    func DatenAuslesen() -> [Int]
    {
        return daten
    }
}

/**
Die Klasse löst das Teilsummenproblem (Subset‑Sum) mit einem Ansatz dynamischer Programmierung

- author: Johannes Neumeyer)
- version 07.08.25
 */
class MaximaleTeilsumme 
{   
    /** Die auszuwertenden Daten */
    var daten: [Int]

    /**
    Der Konstruktor belegt die Daten mit dem Ausschnitt aus der Aufgabe vor.
     */
    init()
    {
        daten = [3, -2, 1, -3, 2, 4, -1, 2]
    }

    /**
	Methode MaximaleSummeEinerTeilfolgeFinden berechnet die maximale Summe einer Teilfolge
     *
     * @param daten Zahlenfeld
     * @param startindex der Startindex
     * @param endindex der Endindex
     * @return maximale Summe 
     */
    private func MaximaleSummeEinerTeilfolgeFinden(daten: [Int], startindex: Int, endindex: Int) -> Int
    
    {
        //ToDo
        return -1
    }

    /**
	MaximaleTeilsummeGesundheitsdatenTesten statet die Berechnung der maximalen
	Teilsumme für die Zahlenfolge und gibt das Ergebnis aus
     */
    func MaximaleTeilsummeGesundheitsdatenTesten()
    {
		print("Maximale Teilsumme: \(MaximaleSummeEinerTeilfolgeFinden(daten: daten, startindex: 0, endindex: daten.count - 1))")
    }

    /**
	Die Methode DatenEinlesen liest Daten (pro Zeile ein Pulswert als ganze Zahl)
	aus einer Textdatei aus und speichert sie in dem Feld daten
     - parameters:
     		- dateiname: Name der Datei mit den Daten
     */
    func DatenEinlesen(dateiname: String)
    {
        let reader = TextFileReader(dateiname: dateiname)

        daten = reader.DatenAuslesen();
        print("\(daten.count) Daten eingelesen.")
    }
}

let m = MaximaleTeilsumme()
m.MaximaleTeilsummeGesundheitsdatenTesten()
m.DatenEinlesen(dateiname: "daten1.csv")
m.MaximaleTeilsummeGesundheitsdatenTesten()
m.DatenEinlesen(dateiname: "daten2.csv")
m.MaximaleTeilsummeGesundheitsdatenTesten()
