import numpy as np
import tensorflow as tf
#Deaktivieren der Verwendung von GPU
tf.config.set_visible_devices([], 'GPU')


#####################################
# Daten importieren und vorbereiten
####################################

# Daten laden und in Trainings- und Testdaten aufteilen
# Es handelt sich um den MNIST-Datensatz, der Bilder von handschriftlichen Ziffern enthält
(train_data, train_labels), (test_data, test_labels) = tf.keras.datasets.mnist.load_data()

# Bilder auf den Bereich [0, 1] normieren
train_data = train_data.astype("float32") / 255
test_data = test_data.astype("float32") / 255

# Farbkanal zu den Daten hinzufügen (in diesem Fall einer weil es nur Grauwerte sind)
train_data = np.expand_dims(train_data, -1)
test_data = np.expand_dims(test_data, -1)


# Label müssen in Vektoren umgewandelt werden
num_classes = 10
train_labels = tf.keras.utils.to_categorical(train_labels, num_classes)
test_labels = tf.keras.utils.to_categorical(test_labels, num_classes)

####################
# Modell entwickeln
###################
model = tf.keras.Sequential()
# Definition der Eingabeschicht
model.add(tf.keras.layers.Input(shape=(28,28,1)))
# Flatten-Schicht wandelt die 2-dimensionale Eingabe in einen 1-dimensionalen Vektor um
model.add(tf.keras.layers.Flatten())
model.add(tf.keras.layers.Dense(2, activation="relu"))
model.add(tf.keras.layers.Dense(10, activation="sigmoid"))

# Übersicht über das Modell wird ausgegeben
model.summary()

#################################
# Modell trainieren und testen
################################

model.compile(loss="categorical_crossentropy", optimizer="adam", metrics=["accuracy"])

model.fit(train_data, train_labels, batch_size=100, epochs=5)

#Modell testen und Ergebnis ausgeben.
score = model.evaluate(test_data, test_labels)
print("Test loss:", score[0])
print("Test accuracy:", score[1])