import random
import math
from typing import List, Tuple

# ---------- Typalias ----------
DATENPUNKT = Tuple[float, float]
GANZZAHL    = int
KOMMAZAHL   = float

# ---------- Beispieldatensatz (drei dichte Gruppen) ----------
def BeispieldatenErzeugen() -> List[DATENPUNKT]:
    random.seed(42)
    daten: List[DATENPUNKT] = []
    # Cluster A um (5, 5)
    daten += [(random.gauss(2, 0.6),  random.gauss(5, 0.6))  for _ in range(6)]
    # Cluster B um (12, 2)
    daten += [(random.gauss(12, 0.6), random.gauss(6, 0.6)) for _ in range(6)]
    # Cluster C um (3, 12)
    daten += [(random.gauss(8, 0.6),  random.gauss(12, 0.6)) for _ in range(6)]
    return daten

# ---------- Lehrtext-Methoden ----------
def ClusterzentrenInitialisieren(k: GANZZAHL) -> List[DATENPUNKT]:
    """Schritt 2 – wähle k zufällige Datenpunkte als Startzentren."""
    zentren = []
    # TODO
    pass

    # Alternativ, wenn die Punkte zufällig gewählt werden sollen
    #return random.sample(daten, k) # hier zusätzlicher Methodenparameter daten: List[DATENPUNKT] notwendig
    

def AbstandBerechnen(p1: DATENPUNKT, p2: DATENPUNKT) -> KOMMAZAHL:
    """Euklidischer Abstand."""
    # TODO
    pass

def DatenpunkteClusternZuordnen(
        daten: List[DATENPUNKT],
        clusterzentren: List[DATENPUNKT]
) -> List[GANZZAHL]:
    """Schritt 3 – jedem Punkt das nächstgelegene Zentrum zuordnen."""
    zuordnung: List[GANZZAHL] = []
    # TODO
    pass

def ClusterzentrenAktualisieren(
        daten: List[DATENPUNKT],
        clusterzentren: List[DATENPUNKT],
        zuordnung: List[GANZZAHL]
) -> List[DATENPUNKT]:
    """Schritt 4 – Mittelwerte pro Cluster bilden und Zentren verschieben."""
    k = len(clusterzentren)
    summenX   = [0.0]*k
    summenY   = [0.0]*k
    clustergrößen = [0]*k
    # TODO
    pass

def kMeansDurchführen(
        daten: List[DATENPUNKT],
        k: GANZZAHL,
        iterationen: GANZZAHL
):
    """Schritt 5 – iterativer Hauptalgorithmus."""
    zentren = ClusterzentrenInitialisieren(k)
    for it in range(iterationen):
        # TODO
        FortschrittAusgeben(it+1, daten, zentren, zuordnung)
    return zentren, zuordnung

# ---------- Minimal-„Grafik“ mittels ASCII ----------
def FortschrittAusgeben(iteration: GANZZAHL,
                        daten: List[DATENPUNKT],
                        zentren: List[DATENPUNKT],
                        zuordnung: List[GANZZAHL]) -> None:
    """Zeigt nach jeder Iteration Zentren und eine grobe ASCII-Karte (20 × 20)."""
    print(f"\n=== Iteration {iteration} ===")
    for idx, z in enumerate(zentren):
        print(f"Zentrum {idx}: ({z[0]:.2f}, {z[1]:.2f})   Punkte im Cluster: {zuordnung.count(idx)}")

    width = height = 20           # Rastergröße
    scale = 15.0 / width          # Datenbereich ≈ 0–15
    raster = [[" "]*(width+1) for _ in range(height+1)]

    syms = "abcde"                # Cluster-Marker (bis 5 Cluster)
    for (x, y), cl in zip(daten, zuordnung):
        rx = min(int(x/scale), width)
        ry = min(int(y/scale), height)
        raster[height-ry][rx] = syms[cl]

    for ci, (x, y) in enumerate(zentren):
        rx = min(int(x/scale), width)
        ry = min(int(y/scale), height)
        raster[height-ry][rx] = "X"           # Zentrum als großes X

    for row in raster:
        print("".join(row))
    print()


# ---------- Main ----------
def Main() -> None:
    daten = BeispieldatenErzeugen()
    k = 3
    iterationen = 5
    finaleZentren, _ = kMeansDurchführen(daten, k, iterationen)
    print("Finale Zentren:", ["(%.2f, %.2f)" % z for z in finaleZentren])

# Wenn als Skript ausgeführt
if __name__ == "__main__":
    Main()